function h=current_figure(inputFile,bin,vec_scale)
% Purpose: plot currents on ship track map from skeletton and final files
%
% Variables:
%	- inputFile: full path to data matfile to process (optional: asked if not provided)
%	- bin: number of the cell to plot (optional: DEFAULT_BIN or
%	DEFAULT_BIN_1 (if 1m cells) if not provided)
%	- vec_scale: scale factor (optional: MAP_VEC_SCALE_FACTOR if not provided)
%	- h: figure handler
%
% Global variables: WORK_DIR, DEFAULT_BIN, DEFAULT_BIN_1, SCALE_PLOT,
% MAP_VEC_SCALE_FACTOR

% Global variables
global WORK_DIR
global DEFAULT_BIN
global DEFAULT_BIN_1
global SCALE_PLOT
global MAP_VEC_SCALE_FACTOR

% Processing arguments
if nargin==0
   % Ask user for input file
   originalDir=pwd;
   cd (WORK_DIR);
   [fileName,pathName]=uigetfile('*.mat','Slection du fichier  traiter');
   inputFile=[pathName fileName];
   cd (originalDir);
   % Testing and loading file
   test_file(inputFile);
   s=load(inputFile);
   if s.ConfigADCP.cellLength == 1
      bin=DEFAULT_BIN_1;
   else
      bin=DEFAULT_BIN;
   end
   vec_scale=MAP_VEC_SCALE_FACTOR;
elseif nargin ==1 
   % Testing and loading file
   test_file(inputFile);
   s=load(inputFile);
   if s.ConfigADCP.cellLength == 1
      bin=DEFAULT_BIN_1;
   else
      bin=DEFAULT_BIN;
   end
   vec_scale=MAP_VEC_SCALE_FACTOR;
elseif nargin ==2
   vec_scale=MAP_VEC_SCALE_FACTOR;
   % Testing and loading file
   test_file(inputFile);
   s=load(inputFile);
elseif nargin ==3
   test_file(inputFile);
   s=load(inputFile);   
elseif nargin > 3
   error('Bad number of arguments\n');
end

% Verifying processing status
if (s.fileProcessingStatus < 2)
   error(['Skeletton of ' inputFile ' must be donne first !']);
end

% Coordinates: lon=14, lat=13
dlon=max(s.ensemble(:,14))-min(s.ensemble(:,14));
x=min(s.ensemble(:,14))+0.2*dlon;
y=max(s.ensemble(:,13));

% Plotting Track
h=m_plot_track(s.ensemble(:,13),s.ensemble(:,14));
figure(h);
set(gcf,'PaperType','a4');

% Plotting in green if there is bottom
good=find(~isnan(s.bottom));
if ~isempty(good)
    m_plot(s.ensemble(good,14),s.ensemble(good,13),'g.');
end

% Current vectors

%m_quiver([s.ensemble(:,14);x],[s.ensemble(:,13);y],...
%   [s.eastCurrentComponent(:,bin);SCALE_PLOT],...
%   [s.northCurrentComponent(:,bin);0],vec_scale,'.');

m_vec(vec_scale,[s.ensemble(:,14);x],[s.ensemble(:,13);y],...
   [s.eastCurrentComponent(:,bin);SCALE_PLOT],...
   [s.northCurrentComponent(:,bin);0],'b','headangle',30,'shaftwidth',0.2,'headlength',1);

%m_elev('contour',[20 50 100],'edgecolor','b');

% Legend
m_text(min(s.ensemble(:,14)),y,[num2str(SCALE_PLOT) ' cm/s ']);
title(['Carte des courrants session ' s.Session.sessionName ' : ' s.Session.insuName ' Bin: ' num2str(bin)],...
   'Interpreter','none');

% zoom
zoom on
