function h=m_plot_track(lat,lon,options)
% Purpose: plot ship track on map
%
% Variables:
%	- lat: vector of latitudes
%	- lon: vector of longitudes
%	- options: plotting options: 'limits' (optional)
%	- h: figure handler
%
% Global variables: DATA_DIR

% Global variables
global DATA_DIR

% Processing argument
if nargin <2 | nargin>3
   error('Bad number of arguments\n');
end

h=figure;
set(gcf,'PaperType','a4');
hold on;

% Axes
deltalon=0.15*(abs(min(lon)-max(lon)));
deltalat=0.15*(abs(min(lat)-max(lat)));
lat_south=min(lat)-deltalat;
lat_north=max(lat)+deltalat;
long_west=min(lon)-deltalon;
long_east=max(lon)+deltalon;

% Plotting
m_proj('mercator','longitude',[long_west long_east],'latitude',[lat_south lat_north]);

% Sandwell bathymetry
% [elevations,lat,lon]=mygrid_sand([lat_south lat_north long_west long_east],1);
%m_contour(lon,lat,elevations,'linespec','k');

m_usercoast([DATA_DIR filesep 'gshhs_h_medit.mat'],'patch',[.7 .7 .7],'edgecolor','k');
m_grid('box','fancy','tickdir','out');
m_plot(lon,lat,'r');


% Optional limits
if (nargin==3 & options=='limits')
   m_text(lon(1),lat(1),'Dbut \rightarrow','Color','b','FontSize',8,'HorizontalAlignment','right'); 
   m_text(lon(length(lon)),lat(length(lat)),'\leftarrow Fin','Color','b','FontSize',8); 
end

% Legends
title('Route du TETHYS II');
zoom on;

%%%%%%%%%%%%%%%%%%%%
% Button bar layout
%%%%%%%%%%%%%%%%%%%%

buttons(1).str='Position';
buttons(1).callback='call_positions';

buttons(2).str='Distance';
buttons(2).callback='call_distance';

h_button_bar(gcf,buttons);
