function h=stick_plot_figure (inputFile,binsToPlot,ensembleBegin,ensembleEnd)
% Purpose: plot current sticks from skeletton and final files
%
% Variables:
%	- inputFile: full path to data matfile to process (optional: asked if not provided)
%	- BinsToPlot: vector of cell numbers to plot  (optional: DEFAULT_BINS_TO_PLOT or
%	DEFAULT_BINS_TO_PLOT_1 (if 1m cells) if not provided)
%	- ensembleBegin: number of the first ensemble to plot (optional: begin
%	if not provided)
%	- ensembleEnd: number of the last ensemble to plot (optional: end if
%	not provided)
%	- h: figure handler
%
% Global variables: global DEFAULT_BINS_TO_PLOT, DEFAULT_BINS_TO_PLOT_1,
% SCALE_PLOT, WORK_DIR

% Global variables
global DEFAULT_BINS_TO_PLOT
global DEFAULT_BINS_TO_PLOT_1
global SCALE_PLOT
global WORK_DIR

% Function built-in variables
MAX_BIN_PLOT=11;       % Max number of bin plot + 1
BIN_PLOT_DISTANCE=100; % Distance between bin plots in cm/s
QUIVER_SCALE_FACTOR=0;

% Processing argument
if nargin == 0
% Ask user for input file
   originalDir=pwd;
   cd (WORK_DIR);
   [fileName,pathName]=uigetfile('*.mat','Slection du fichier  traiter');
   inputFile=[pathName fileName];
   cd (originalDir)
elseif nargin==3 | nargin >4
   error('Bad number of arguments');
end

% Testing and loading file
test_file(inputFile);
s=load (inputFile);

% Verifying processing status
if (s.fileProcessingStatus < 2)
   error(['Skeletton of ' inputFile ' must be donne first !']);
end

% Processing arguments
if nargin==0 | nargin==1 | nargin==2
   ensembleBegin=1;
   ensembleEnd=length(s.ensemble);
end
if nargin==0 | nargin==1 
   if s.ConfigADCP.cellLength == 1
      binsToPlot=DEFAULT_BINS_TO_PLOT_1; 
   else
      binsToPlot=DEFAULT_BINS_TO_PLOT;
   end
end

% Figure
h=figure('PaperType','a4');
hold on;

% Constructing matrix
nBinsToPlot=length(binsToPlot);
if nBinsToPlot>MAX_BIN_PLOT
   nBinsToPlot=MAX_BIN_PLOT;
   binsToPlot=binsToPlot(1:nBinsToPlot);
end

x=[ensembleBegin:ensembleEnd];
y=[1:nBinsToPlot]*BIN_PLOT_DISTANCE;
u=[s.northCurrentComponent(ensembleBegin:ensembleEnd,binsToPlot)]';
v=-1*[s.eastCurrentComponent(ensembleBegin:ensembleEnd,binsToPlot)]';

% Axis
axis image;

% Plotting vectors
quiver(x,y,u,v,QUIVER_SCALE_FACTOR,'.b');

% Arrow legends
quiver (s.nEnsembles/2,11,0,SCALE_PLOT,QUIVER_SCALE_FACTOR,'b');
quiver (s.nEnsembles/2,11,SCALE_PLOT,0,QUIVER_SCALE_FACTOR,'b');

% Legend text
text((ensembleEnd+ensembleBegin)*.5,BIN_PLOT_DISTANCE/2,[num2str(SCALE_PLOT) ' cm/s'],'HorizontalAlignment','center','FontSize',6); 

% Plotting bottom
test_bottom=s.bottom(ensembleBegin:ensembleEnd);
test_bottom(find(~isnan(test_bottom)))=(MAX_BIN_PLOT-1)*BIN_PLOT_DISTANCE;
plot(test_bottom,'rx');
text((ensembleEnd+ensembleBegin)*.5,(MAX_BIN_PLOT-0.5)*BIN_PLOT_DISTANCE,...
   'Prsence du fond','HorizontalAlignment','center');

tickLabel=((binsToPlot)-1)*s.ConfigADCP.cellLength+s.ConfigADCP.bin1Distance;
tick=linspace(1,nBinsToPlot,nBinsToPlot)*BIN_PLOT_DISTANCE;

set(gca,'ytick',tick);
set(gca,'yticklabel',tickLabel);
ylabel('Profondeur (m)');
xlabel('Ensembles');
title(['Profil des courrants session ' s.Session.sessionName ' : ' s.Session.insuName],'Interpreter','none');
