function gui_grid_current
% Purpose: GUI for grid current plotting
%
% Variables: none
%
% Global variables: DEFAULT_BIN, WORK_DIR, MAP_VEC_SCALE_FACTOR

% Using some global variables
global DEFAULT_BIN
global WORK_DIR
global MAP_VEC_SCALE_FACTOR

DEFAULT_GRID=30 % points

% Arguments processing
if nargin>0
   error('Bad number of arguments\n');
end

% Get input
originalDir=pwd;
cd (WORK_DIR);
[fileName,pathName]=uigetfile('*.mat','Slection du fichier  tracer');
inputFile=[pathName fileName];
cd (originalDir)

% Testing and loading file
test_file(inputFile);
s=load (inputFile);

% Verifying processing status
if (s.fileProcessingStatus < 2)
   error(['Skeletton of ' inputFile ' must be donne first !']);
end

minLat=floor(min(s.ensemble(:,13))*100)/100;
minLon=floor(min(s.ensemble(:,14))*100)/100;
maxLat=ceil(max(s.ensemble(:,13))*100)/100;
maxLon=ceil(max(s.ensemble(:,14))*100)/100;

stepLat=floor(1000*abs(maxLat-minLat)/DEFAULT_GRID)/1000;
stepLon=floor(1000*abs(maxLon-minLon)/DEFAULT_GRID)/1000;

%gridLat=[minLat:stepLat:maxLat];
%gridLon=[minLon:stepLon:maxLon];

prompt = {'Bins  tracer','Facteur d''echelle: ','Grille de longitude','Grille de latitude'};
dlg_title = 'Grid current plot';
num_lines= 1;
def     = {num2str(DEFAULT_BIN),num2str(MAP_VEC_SCALE_FACTOR),...
        sprintf('[%.2f:%.3f:%.2f]',minLon,stepLon,maxLon),...
        sprintf('[%.2f:%.3f:%.2f]',minLat,stepLat,maxLat)};
answer  = inputdlg(prompt,dlg_title,num_lines,def);

binToPlot=str2num(answer{1});
factorScale=str2num(answer{2});
gridLon=str2num(answer{3})
gridLat=str2num(answer{4});

grid_current_plot(inputFile,gridLon,gridLat,binToPlot,factorScale);
