function gui_stick_plot
% Purpose: GUI for current stick plotting
%
% Variables: none
%
% Global variables: DEFAULT_BINS_TO_PLOT, WORK_DIR

% Using some global variables
global DEFAULT_BINS_TO_PLOT
global WORK_DIR

% Arguments processing
if nargin>0
   error('Bad number of arguments\n');
end

% Get input
originalDir=pwd;
cd (WORK_DIR);
[fileName,pathName]=uigetfile('*.mat','Slection du fichier  tracer');
inputFile=[pathName fileName];
cd (originalDir)

% Testing and loading file
test_file(inputFile);
s=load (inputFile);

% Verifying processing status
if (s.fileProcessingStatus < 2)
   error(['Skeletton of ' inputFile ' must be donne first !']);
end

prompt = {'Bins  tracer:','Premier ensemble:','Dernier ensemble:'};
dlg_title = 'Stick plot';
num_lines= 1;
def     = {num2str(DEFAULT_BINS_TO_PLOT),'premier','dernier'};
answer  = inputdlg(prompt,dlg_title,num_lines,def);

binsToPlot=str2num(answer{1});

% Processing options
if (strncmpi(answer{2},'premier',7)) & (strncmpi(answer{3},'dernier',7))
   stick_plot_figure(inputFile,binsToPlot);
elseif ~(strncmpi(answer{2},'premier',7)) & (strncmpi(answer{3},'dernier',7))
   stick_plot_figure(inputFile,binsToPlot,str2num(answer{2}),s.nEnsembles);
elseif (strncmpi(answer{2},'premier',7)) & ~(strncmpi(answer{3},'dernier',7))
   stick_plot_figure(inputFile,binsToPlot,1,str2num(answer{3})); 
else
   stick_plot_figure(inputFile,binsToPlot,str2num(answer{2}),str2num(answer{3}));
end
