function h_button_bar(parent,buttons)
% Purpose: display an horizontal button bar in a figure
%
% Variables: 
% 	- parent : figure which will contain the buttons (needed)
% 	- buttons: vector of structures containing buttons parameters (needed)
%      * buttons.str: button label
%      * buttons.callback: button callback function
%      * buttons.bgcolor: button background color
%
% Global variables: XSPACING, YPADDING

% Using some global variables
global XPADDING;
global YPADDING;

% Arguments processing
if nargin ~= 2
   error('Bad number of arguments');
end

% get button number
nb=length(buttons);

% Get figure size
pos_fig=get(parent,'Position');

offset_button=0;
newpos=zeros(1,4);

for i=1:nb
   
   % Button1 lay out
   offset_button=offset_button+newpos(3);
   button=uicontrol(parent,'Position',[offset_button 0 1 1],'Visible','Off');
   
   % Wrapping button string
   [outstring,newpos] = textwrap(button,cellstr(buttons(i).str));
   newpos=[offset_button 0 newpos(3)+XPADDING newpos(4)+YPADDING];
   
   % If there are too many buttons for the figure width, resize it
   delta=offset_button+newpos(3)-pos_fig(3);
   
   if (delta>0)
      set(parent,'Position',[pos_fig(1)-delta/2 pos_fig(2) pos_fig(3)+delta pos_fig(4)]);
   end
   
   % Display button
   set(button,'Position',newpos,'Visible','On','String',outstring,'callback',buttons(i).callback);
   
end
