function fig=v_button_box(name,button)
% Purpose: create a vertical button bar
%
% Variables: 
% 	- name : name of the figure which will contain the buttons (needed)
% 	- button: vector of structures containing buttons parameters (needed)
%      * button.str: button label
%      * button.callback: button callback function
%      * button.bgcolor: button background color
%
% Global variables: XSPACING, YSPACING, XPADDING, YPADDING

% Using some global variables
global XSPACING
global YSPACING
global XPADDING
global YPADDING

% Arguments processing
if nargin ~= 2
   error('Bad number of arguments');
end

% Default dialog box invisible for now
fig=figure('Name',name,'Visible','Off','MenuBar','none');

max_width=0;
max_height=0;

nb=length(button);

for i=1:nb
   
   % Default position
   pos(i,:)=grid_gui(fig,[i,1],[nb,1]);
   h(i)=uicontrol(fig,'Position',pos(i,:));
   
   % Wrapping string
   [outstring(i,:),newpos] = textwrap(h(i),cellstr(button(i).str));
   newpos(3)=newpos(3)+XPADDING;
   newpos(4)=newpos(4)+YPADDING;
   
   % Record max width and max height
   if (newpos(3)>max_width)
      max_width=newpos(3);
   end
   
   if (newpos(4)>max_height)
      max_height=newpos(4);
   end
   
end

% Compute the new size of the dialog box
pos_fig=get(fig,'Position');
scrsz = get(0,'ScreenSize');

pos_fig(3)=(max_width+2*XSPACING);
pos_fig(4)=(nb*max_height+ (nb+1)*YSPACING);

pos_fig(1)=(scrsz(3)-pos_fig(3))/2;
pos_fig(2)=(scrsz(4)-pos_fig(4))/2;

set(fig,'Position',pos_fig);

% Set well sized buttons to the correct place in dialog box
for i=1:nb
   pos(i,:)=grid_gui(fig,[i,1],[nb,1]);
   set(h(i),'Position',[pos(i,1),pos(i,2),max_width,max_height],'String',outstring(i,:),'Callback',button(i).callback);
   set(h(i),'BackgroundColor',button(i).bgcolor);
end

% Set visible the well sized dialog box
set(fig,'Visible','On');

% Store button and figure handles in figure
s.buttonHandles=h;
s.figureHandle=fig;
set(fig,'UserData',s);

