function saved_lite(working_directory)
% Purpose: initialise all global variables and launch SAVED lite
%
% Variables: 
%	- working_directory: directory where processing SAVED files
%		(optional: pwd/tmp if not specified)
%
% Global variables: all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FIGURE DEFAULT PROPERTIES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

set(0,'DefaultFigurePaperType','a4');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PATH VARIABLES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% PROG ROOT: root of the tree prog
global PROG_ROOT
PROG_ROOT='x:\v4.1_lite';

if (nargin ==0)
    working_directory=[PROG_ROOT filesep 'tmp'];
elseif (nargin > 1)
    error('Bad number of arguments');      
else
    if (~exist(working_directory,'dir'))
        err=sprintf('Directory %s doesnt exist or is not a directory',path_to_dir);
        error(err);
    end
end

path(path,PROG_ROOT);

% Setting the search path
path(path,fullfile(PROG_ROOT,'m_map'));
path(path,fullfile(PROG_ROOT,'adcp_plotting'));
path(path,fullfile(PROG_ROOT,'adcp_plotting_ihm'));
path(path,fullfile(PROG_ROOT,'common_data'));
path(path,fullfile(PROG_ROOT,'common_ihm'));
path(path,fullfile(PROG_ROOT,'common_misc'));

% Working directory
global WORK_DIR
WORK_DIR=working_directory;
fprintf('Rpertoire de travail = %s\n',working_directory);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% EXTERN PROGRAM CALL PATH
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global DATA_DIR
DATA_DIR=fullfile(PROG_ROOT,'common_data');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% IHM VARIABLES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global XPADDING
XPADDING=10;

global YPADDING
YPADDING=10;

global XSPACING
XSPACING=10;

global YSPACING
YSPACING=10;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PLOTTING VARIABLES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global ENS_LEGEND_SPACING
ENS_LEGEND_SPACING=60;

% Default bin to plot in stick plot
global DEFAULT_BINS_TO_PLOT
DEFAULT_BINS_TO_PLOT=[50  40  30  20  10  5  3  2  1];

global DEFAULT_BINS_TO_PLOT_1
DEFAULT_BINS_TO_PLOT_1=[50  40  35  30  25  20  15  10  5];

% Default bin on current map
global DEFAULT_BIN
DEFAULT_BIN=3;

global DEFAULT_BIN_1
DEFAULT_BIN_1=20;

% Vector scale to display
global SCALE_PLOT
SCALE_PLOT=30;

% Quiver scale factor for current figure
global MAP_VEC_SCALE_FACTOR
MAP_VEC_SCALE_FACTOR=50;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LAUNCH SAVED
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

gui_plotting;
