function call_ensemble
% Purpose: callback function to return the nearest ensemble from the cursor position
%
% Variables: none
%
% Global variables: none

[x,y] = ginput(1);
[lon,lat]=m_xy2ll(x,y);

s=get(gcbf,'UserData');

d=inf;
n=0;
for i=1:length(s.coord)
    dist=m_lldist([lon;s.coord(i,2)],[lat;s.coord(i,1)]);
    if dist<d
        d=dist;
        n=i;
    end
end

str=sprintf('Ensemble %i\n',n);
helpdlg(str,'Ensemble');