function h=current_figure(inputFile,bin,vec_scale)
% Purpose: plot currents on ship track map from skeletton and final files
%
% Variables:
%	- inputFile: full path to data matfile to process (optional: asked if not provided)
%	- bin: number of the cell to plot (optional: DEFAULT_BIN or
%	DEFAULT_BIN_1 (if 1m cells) if not provided)
%	- vec_scale: scale factor (optional: MAP_VEC_SCALE_FACTOR if not provided)
%	- h: figure handler
%
% Global variables: WORK_DIR, DEFAULT_BIN, DEFAULT_BIN_1, SCALE_PLOT,
% MAP_VEC_SCALE_FACTOR, MAP_LAT_PADDING, MAP_LON_PADDING

% Global variables
global WORK_DIR
global DEFAULT_BIN
global DEFAULT_BIN_1
global SCALE_PLOT
global MAP_VEC_SCALE_FACTOR
global MAP_LAT_PADDING
global MAP_LON_PADDING

% Processing arguments
if nargin==0
   % Ask user for input file
   originalDir=pwd;
   cd (WORK_DIR);
   [fileName,pathName]=uigetfile('*.mat','Slection du fichier  traiter');
   inputFile=[pathName fileName];
   cd (originalDir);
   % Testing and loading file
   test_file(inputFile);
   s=load(inputFile);
   if s.ConfigADCP.cellLength == 1
      bin=DEFAULT_BIN_1;
   else
      bin=DEFAULT_BIN;
   end
   vec_scale=MAP_VEC_SCALE_FACTOR;
elseif nargin ==1 
   % Testing and loading file
   test_file(inputFile);
   s=load(inputFile);
   if s.ConfigADCP.cellLength == 1
      bin=DEFAULT_BIN_1;
   else
      bin=DEFAULT_BIN;
   end
   vec_scale=MAP_VEC_SCALE_FACTOR;
elseif nargin ==2
   vec_scale=MAP_VEC_SCALE_FACTOR;
   % Testing and loading file
   test_file(inputFile);
   s=load(inputFile);
elseif nargin ==3
   test_file(inputFile);
   s=load(inputFile);   
elseif nargin > 3
   error('Bad number of arguments\n');
end

% Verifying processing status
if (s.fileProcessingStatus < 2)
   error(['Skeletton of ' inputFile ' must be donne first !']);
end

% Plotting Track
h=m_plot_track(s.ensemble(:,13),s.ensemble(:,14));
figure(h);
set(gcf,'PaperType','a4');
orient tall;

% Plotting in green if there is bottom
la=s.ensemble(:,13);
lo=s.ensemble(:,14);
lo(find(isnan(s.bottom)))=NaN;
la(find(isnan(s.bottom)))=NaN;
m_plot(lo,la,'g');

% Current vectors
m_vec(vec_scale,[s.ensemble(:,14)],[s.ensemble(:,13)],...
    [s.eastCurrentComponent(:,bin)],[s.northCurrentComponent(:,bin)],...
    'b','headangle',30,'shaftwidth',0.2,'headlength',1);

[hpv5, htv5] = m_vec(vec_scale, min(s.ensemble(:,14))-MAP_LON_PADDING/2, max(s.ensemble(:,13))+MAP_LAT_PADDING/2, ...
    SCALE_PLOT, 0, 'b','headangle',30,'shaftwidth',0.2,'headlength',1,'key', [num2str(SCALE_PLOT) 'cm/s']);
set(htv5,'FontSize',6,'Color','k');

% Legend
if ~isfield(s,'alpha')
    s.alpha=NaN;
end
if ~isfield(s,'phi')
    s.phi=NaN;
    
end

title(['Carte des courants session ' s.Session.sessionName ' : ' s.Session.insuName ...
    ' Bin: ' num2str(bin) ', Alpha=' num2str(s.alpha) ', Phi=' num2str(s.phi)], ...
    'Interpreter','none');

% zoom
zoom on
