function h=grid_current_plot(inputFile,lonGrid,latGrid,bin,vec_scale)
% Purpose: plot currents on a regulary spaced grid map from skeletton and
% final files
%
% Variables:
%	- inputFile: full path to data matfile to process (needed)
%   - lonGrid: vector containing longitude grid (needed)
%   - latGrid: vector containing latitude grid (needed)
%	- bin: number of the cell to plot (needed)
%	- vec_scale: scale factor (optional: MAP_VEC_SCALE_FACTOR if not provided)
%	- h: figure handler
%
% Global variables:  SCALE_PLOT, MAP_VEC_SCALE_FACTOR, MAP_LAT_PADDING, MAP_LON_PADDING

global SCALE_PLOT
global MAP_VEC_SCALE_FACTOR
global MAP_LAT_PADDING
global MAP_LON_PADDING

if nargin==4
    vec_scale=MAP_VEC_SCALE_FACTOR;
elseif nargin <4 | nargin > 5
    error('Bad number of arguments\n');
end

% Loading file
test_file(inputFile);
s=load(inputFile);

% Verifying processing status
if (s.fileProcessingStatus < 2)
    error(['Skeletton of ' inputFile ' must be donne first !']);
end

% Computing grid
[lonI,latI] = meshgrid(lonGrid,latGrid);

east = GRIDDATA(s.ensemble(:,14),s.ensemble(:,13),s.eastCurrentComponent(:,bin),lonI,latI);
north = GRIDDATA(s.ensemble(:,14),s.ensemble(:,13),s.northCurrentComponent(:,bin),lonI,latI);

[n,m]=size(lonI);
nGrid=n*m;

% Plotting Track
h=m_plot_track(s.ensemble(:,13),s.ensemble(:,14));
figure(h);
set(gcf,'PaperType','a4');
hold on

% Plotting grid
m_plot(lonI,latI,'g+');

% Computing currents
x2=reshape(lonI,1,nGrid);
y2=reshape(latI,1,nGrid);
u2=reshape(east,1,nGrid);
v2=reshape(north,1,nGrid);

% Plotting currents
m_vec(vec_scale,x2,y2,u2,v2,...
    'b','headangle',30,'shaftwidth',0.2,'headlength',1);

[hpv5, htv5] = m_vec(vec_scale, min(x2)-MAP_LON_PADDING/2, max(y2)+MAP_LAT_PADDING/2, ...
    SCALE_PLOT, 0, 'b','headangle',30,'shaftwidth',0.2,'headlength',1,'key', [num2str(SCALE_PLOT) 'cm/s']);
set(htv5,'FontSize',6,'Color','k');

% Legend
if ~isfield(s,'alpha')
    s.alpha=NaN;
end
if ~isfield(s,'phi')
    s.phi=NaN;
end

title(['Carte des courants session ' s.Session.sessionName ' : ' s.Session.insuName ...
    ' Bin: ' num2str(bin) ', Alpha=' num2str(s.alpha) ', Phi=' num2str(s.phi)], ...
    'Interpreter','none');

% zoom
zoom on
