function h=heading_figure(inputFile)
% Purpose: plot heading sources and differences between them
%
% Variables:
%	- inputFile: full path to data matfile to process (optional: asked if not provided)
%	- h: figure handler
%
% Global variables: WORK_DIR

% Global variables
global WORK_DIR 

% Processing arguments
if nargin==0
   % Ask user for input file
   originalDir=pwd;
   cd (WORK_DIR);
   [fileName,pathName]=uigetfile('*.mat','Slection du fichier  traiter');
   inputFile=[pathName fileName];
   cd (originalDir);
elseif nargin > 1
   error('Bad number of arguments\n');
end

% Testing and loading file
test_file(inputFile);
s=load(inputFile);

% Angle computations
diffGyroVtg=zeros(s.nEnsembles,1).*NaN;
diffGyroAtta=diffGyroVtg.*NaN;
diffBottomVtg=diffGyroVtg.*NaN;
btSpeedDir=diffGyroVtg.*NaN;

for i=1:s.nEnsembles
      
   if ~isnan(s.sensors(i,1))  
      % Gyro - vtg
      if ~isnan(s.vtgSpeed(i,1)) & ~isnan(s.vtgSpeed(i,2))  
         [gyro(1),gyro(2)]=dirspeed2uv(s.sensors(i,1),1);
         diffGyroVtg(i)=diff_angle_xy (gyro,s.vtgSpeed(i,1:2));
      end
      % Gyro - atta
      if ~isnan(s.attitude(i,1))      
         [atta(1),atta(2)]=dirspeed2uv(s.attitude(i,1),1);
         diffGyroAtta(i)=diff_angle_xy(gyro,atta);
      end
   end
   
   if ~isnan(s.vtgSpeed(i,1)) & ~isnan(s.vtgSpeed(i,2)) &...
         ~isnan(s.btSpeed(i,1)) & ~isnan(s.btSpeed(i,2))
      % Bottom - vtg
      diffBottomVtg(i)=diff_angle_xy (s.btSpeed(i,1:2),-s.vtgSpeed(i,1:2));
      
      % Bottom track true
      [btSpeedDir(i),tmp]=uv2dirspeed(-s.btSpeed(i,1),-s.btSpeed(i,2));
   end
end

% Figure
h=figure('PaperType','a4');


% HEADING
subplot(2,1,1);
set(gca,'Ylim',[0,360],'XLim',[1,s.nEnsembles]);
title(['Caps du TETHYS II session ' s.Session.sessionName ' : ' s.Session.insuName],'Interpreter','none');
hold on;

% Gyro heading
plot (s.sensors(:,1),'k');

% Bottom
plot (btSpeedDir,'b');

% Dir made good
plot (s.ggaSpeed(:,4),'y');

% Attitude
plot (s.attitude(:,1),'r');

% Vtg
plot(s.vtgSpeed(:,4),'g');
plot(s.vtgSpeed(:,3).*0.5,'c');

ylabel('Degrs');
legend('Gyro','Fond','GGA','ATTA','VTG','Speed/2');

set(gca,'YTick',[0:40:360],'YLim',[0,360],'XLim',[1,s.nEnsembles]);
zoom on;


% GYRO - VTG
subplot(6,1,4);

plot(diffGyroVtg,'k');
title('Diffrence entre Gyro et cap VTG: cart gyro + cart du au courant');

ylabel('Degrs');
zoom on;
grid on

good1=find(~isnan(diffGyroAtta));
good2=find(~isnan(diffBottomVtg));

if isempty(good1) | isempty(good2)
   mMin=-10;
   mMax=+10;
else
   m1=mean(diffGyroAtta(good1));
   m2=mean(diffBottomVtg(good2));
   mMin=min(m1,m2)-10;
   mMax=max(m1,m2)+10; 
end

set(gca,'YLim',[mMin mMax],'XLim',[1,s.nEnsembles]);


% BOTTOM - VTG
subplot(6,1,5);

plot(diffBottomVtg,'k');
title('Diffrence entre Fond et cap VTG: cart gyro ');
set(gca,'YLim',[mMin mMax],'XLim',[1,s.nEnsembles]);

ylabel('Degrs');
zoom on;
grid on


% GYRO - ATTA
subplot(6,1,6);

plot(diffGyroAtta,'r');
title('Diffrence entre gyro et ATTA: cart du gyro');

set(gca,'YLim',[mMin mMax],'XLim',[1,s.nEnsembles]);

ylabel('Degrs');
xlabel('Ensembles');
zoom on;
grid on
