function h=recal_figure(inputFile)
% Purpose: plot Gyro and GPS heading sources and correction curve
%
% Variables:
%	- inputFile: full path to data matfile to process (optional: asked if not provided)
%	- h: figure handler
%
% Global variables: WORK_DIR

% Global variables
global WORK_DIR 

% Processing argument
if nargin==0
   % Ask user for input file
   originalDir=pwd;
   cd (WORK_DIR);
   [fileName,pathName]=uigetfile('*.mat','Slection du fichier  traiter');
   inputFile=[pathName fileName];
   cd (originalDir);
elseif nargin > 1
   error('Bad number of arguments\n');
end

% Testing and loading file
test_file(inputFile);
s=load(inputFile);

% Verifying processing status
if (s.fileProcessingStatus <1)
   error(['File ' inputFile ' haven''t already been corrected !']);
end

% Figure
h=figure('PaperType','a4');

% HEADING
subplot(2,1,1);
set(gca,'Ylim',[0,360],'XLim',[1,s.nEnsembles],'YTick',[0:40:360]);
title(['Gyro et ATTA session ' s.Session.sessionName ' : ' s.Session.insuName],'Interpreter','none');
hold on;

% Gyro heading
plot (s.sensors(:,1),'b');

% Attitude
plot (s.attitude(:,1),'r');
ylabel('Degrs');
legend('Gyro','ATTA');
zoom on;

% AZIMUTH CORRECTION
subplot(2,1,2);
set(gca,'XLim',[1,s.nEnsembles]);
title(['Courbe de correction de cap ' s.Session.sessionName ':' s.Session.insuName],'Interpreter','none');
hold on;
plot (s.adcpSpeedCorrection(:,1),'k');
