function h=ref_speed_figure(inputFile)
% Purpose: plot vessel speed sources and reference speed
%
% Variables:
%	- inputFile: full path to data matfile to process (optional: asked if not provided)
%	- h: figure handler
%
% Global variables: WORK_DIR

% Global variables
global WORK_DIR 

% Processing arguments
if nargin==0
   % Ask user for input file
   originalDir=pwd;
   cd (WORK_DIR);
   [fileName,pathName]=uigetfile('*.mat','Slection du fichier  traiter');
   inputFile=[pathName fileName];
   cd (originalDir);
elseif nargin > 1
   error('Bad number of arguments\n');
end

% Testing and loading file
test_file(inputFile);
s=load(inputFile);

% Verifying processing status
if (s.fileProcessingStatus <2)
   error(['Skeletton of ' inputFile ' must be donne first !']);
end

% Figure
h=figure('PaperType','a4');

% Speeds
axes('Position',[0.1, 0.35, 0.8, 0.6]);
hold on;

% vtg
plot (s.vtgSpeed(:,3),'b');

% gga
plot (s.ggaSpeed(:,3),'g');

% bottom
rho = sqrt(s.btSpeed(:,1).^2+s.btSpeed(:,2).^2);
plot (rho,'r');

% layer
rho = sqrt(s.wlSpeed(:,1).^2+s.wlSpeed(:,2).^2);
plot (rho,'k');

% Axis
set(gca,'XLim',[1 s.nEnsembles]);
xlabel('Ensembles');
ylabel('cm/s');
zoom on

% Legend
title(['Vitesses du TETHYS II session ' s.Session.sessionName ' : ' s.Session.insuName],'Interpreter','none');
legend('VTG','GGA','BT','WL');

% Ref speed
axes('Position',[0.1, 0.05, 0.8, 0.2]);

% reference index
refIndex=zeros(1,s.nEnsembles).*NaN;
for i=1:s.nEnsembles
   if s.vesselRefSpeed(i,5) == 1 % Bottom
      refIndex(i)=1;
   elseif s.vesselRefSpeed(i,5) == 2 % VTG
      refIndex(i)=2;
   elseif s.vesselRefSpeed(i,5) == 3 % GGA
      refIndex(i)=3;
   end
end

% Plotting
plot (refIndex,'r');

% Axis
set(gca,'XLim',[1 s.nEnsembles]);
set(gca,'YLim',[0 4],'YTick',[0:4],'YTickLabel',{'';'BT';'VTG';'GGA';''});

% Legends
xlabel('Ensembles');
ylabel('Vitesses');

title(['Choix de la vitesse de rfrence du TETHYS II session ' s.Session.sessionName ' : ' s.Session.insuName],'Interpreter','none');
