function h=track_figure(inputFile)
% Purpose: plot ship track on map
%
% Variables:
%	- inputFile: full path to data matfile to process (optional: asked if not provided)
%	- h: figure handler
%
% Global variables: WORK_DIR, ENS_LEGEND_SPACING
%
% Purpose: Plot ship track on map

% Global variables
global WORK_DIR 
global ENS_LEGEND_SPACING

% Processing arguments
if nargin==0
   % Ask user for input file
   originalDir=pwd;
   cd (WORK_DIR);
   [fileName,pathName]=uigetfile('*.mat','Slection du fichier  traiter');
   inputFile=[pathName fileName];
   cd (originalDir);
elseif nargin > 1
   error('Bad number of arguments\n');
end

% Testing and loading file
test_file(inputFile);
s=load(inputFile);

% Plotting
h=m_plot_track(s.ensemble(:,13),s.ensemble(:,14));

% Ensembles legend
for i=1:ENS_LEGEND_SPACING:s.nEnsembles
   m_text(s.ensemble(i,14),s.ensemble(i,13),['x ' num2str(i)],'Color','b','FontSize',6);
end

title(['Trajet du TETHYS II session ' s.Session.sessionName ' : ' s.Session.insuName],'Interpreter','none');
