function gui_current
% Purpose: GUI for current plotting
%
% Variables: none
%
% Global variables: DEFAULT_BIN, WORK_DIR, MAP_VEC_SCALE_FACTOR

% Using some global variables
global DEFAULT_BIN
global WORK_DIR
global MAP_VEC_SCALE_FACTOR

% Arguments processing
if nargin>0
   error('Bad number of arguments\n');
end

% Get input
originalDir=pwd;
cd (WORK_DIR);
[fileName,pathName]=uigetfile('*.mat','Slection du fichier  tracer');
inputFile=[pathName fileName];
cd (originalDir)

% Testing and loading file
test_file(inputFile);
s=load (inputFile);

% Verifying processing status
if (s.fileProcessingStatus < 2)
   error(['Skeletton of ' inputFile ' must be donne first !']);
end

prompt = {'Bins  tracer','Facteur d''echelle: '};
dlg_title = 'Current plot';
num_lines= 1;
def     = {num2str(DEFAULT_BIN),num2str(MAP_VEC_SCALE_FACTOR)};
answer  = inputdlg(prompt,dlg_title,num_lines,def);

binToPlot=str2num(answer{1});
factorScale=str2num(answer{2});

current_figure(inputFile,binToPlot,factorScale);
