function gui_plotting
% Purpose: main GUI for plotting SAVED adcp data
%
% Variables: none
%
% Global variables: none

% Arguments processing
if nargin>0
   error('Bad number of arguments\n');
end

% PLOTTING TRACK
button(1).str='TRACK PLOT';
button(1).callback='track_figure';
button(1).bgcolor='green';

% PLOTTING HEADING VERIFICATIONS
button(2).str='HEADING PLOT';
button(2).callback='heading_figure';
button(2).bgcolor='green';

% PLOTTING CORRECTED HEADING
button(3).str='CORRECTED HEADING PLOT';
button(3).callback='recal_figure';
button(3).bgcolor='green';

% PLOTTING VESSEL SPEEDS
button(4).str='VESSEL SPEEDS';
button(4).callback='ref_speed_figure';
button(4).bgcolor='green';

% PLOTTING CURRENT STICKS
button(5).str='CURRENT STICKS';
button(5).callback='gui_stick_plot';
button(5).bgcolor='green';

% PLOTTING CURRENT MAP
button(6).str='CURRENT MAP';
button(6).callback='gui_current';
button(6).bgcolor='green';

% PLOTTING GRID CURRENT MAP
button(7).str='GRIDDED CURRENT MAP';
button(7).callback='gui_grid_current';
button(7).bgcolor='green';

h=v_button_box('PLOTTING',button);

% Set figure to non modal
set(h,'WindowStyle','normal','NumberTitle','off');
