function extract_gshhs_shorelines(outputFile,latSpan,lonSpan)
% Purpose: extract shore lines from global shore lines file from GSHHS
%
% Variables: 
%	- outputFile: full path of matfile to create (needed)
%	- latSpan: Span of selected latitudes, ex: [35 46] (needed)
%	- lonSpan: Span of selected longitudes, ex: [-2 20] (needed)
%
% Global variables: none

% Arguments processing
if nargin ~= 3
   error('Bad number of arguments\n');
end

% Creating file
m_proj('mercator','longitude',lonSpan,'latitude',latSpan);
m_gshhs_h('save',outputFile);
