function position=grid_gui(fig,num,nbutton)
% Purpose: compute position of buttons in a vertical dialog box
%
% Variables: 
% 	- fig : figure handle to grid (needed)
% 	- num: vector of length 2 containing the coordinates of the considered
% 	button (needed)
% 	- nbuttons: vector of length 2 containing the maximum of buttons
% 	(needed) 
% 	- position: position of the considered button
%
% Global variables: XSPACING, YSPACING

% Using some global variables
global XSPACING
global YSPACING

% Arguments processing
if nargin ~= 3
   error('Bad number of arguments');
end

pos=get(fig,'Position');

h=pos(4)/nbutton(1);
w=pos(3)/nbutton(2);

bottom=(nbutton(1)-num(1))*h + YSPACING;
left=(num(2)-1)*w + XSPACING;

w=w-2*XSPACING;
h=h-2*YSPACING;

position=[left bottom w h];