function diff=diff_angle_xy (v1,v2)
% Purpose: compute the angle difference in degres between 2 row vectors
% with their xy components
%
% Variables: 
%	-  v1,v2 : vectors of row vectors of components (needed):
% v1 (x1   y1   v2 (x1	y1
%     x2   y2       x2  y2
%     .    .        .   .
%     .    .)       .   .)
%
%	- diff: vector of angle difference in degres
%
% Global variables: none

% Arguments processing
if nargin ~= 2
   error('Bad number of arguments');
end

% Paranoid check
if (length(v1) ~= length(v2))
   error('V1 and V2 must have the same length');
end

% cross product ||u||.||v||.sin(theta)
pv=v1(:,1).*v2(:,2)-v1(:,2).*v2(:,1);

% Scalar product ||u||.||v||.cos(theta)
ps=v1(:,1).*v2(:,1)+v1(:,2).*v2(:,2);

% compute norms of v1,v2
pm=sqrt((v1(:,1).^2+v1(:,2).^2).*(v2(:,1).^2+v2(:,2).^2));

% Angle difference between the 2 vectors
diff=atan2(pv./pm,ps./pm)*180/pi;
