function [u,v]=dirspeed2uv(direction,speed)
% Purpose: transform direction and speed vector coordinates into cartesian
% u, v coordinates
%
% Variables: 
%	- direction: vector of directions in degres (North = 0) (needed)
%	- speed: vector of speeds (needed)
%	- u: vector of U coordinates
%	- v: vector of V coordinates
%
% Global variables: none

% Arguments processing
if nargin ~= 2
   error('Bad number of arguments');
end

direction=direction*pi/180;

u=speed.*sin(direction);
v=speed.*cos(direction);
