function [direction,speed]=uv2dirspeed(u,v)
% Purpose: transform cartesian u, v coordinates vector coordinates into
% direction and speed
% 
% Variables: 
%	- u: vector of U coordinates (needed)
%	- v: vector of V coordinates (needed)
%	- direction: vector of directions in degres (North = 0)
%	- speed: vector of speeds 
%
% Global variables: none

% Arguments processing
if nargin ~= 2
   error('Bad number of arguments');
end

speed=sqrt(u.^2+v.^2);
direction=mod(atan2(u,v)*180/pi+360,360);

